import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiChart from "alexandria-ui-elements/src/displays/components/Chart";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChartExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChartExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChartExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChartExamplesMoldNotifier(this);
		this.requester = new ChartExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a1193335163" format="h6" mode="normal" value="No facets with Html output">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a_250086512" format="filled" layout="vertical" spacing="8">
							<UiChart context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a_250086512.a_1936708868">
							</UiChart>
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a_250086512.a878447497" mode="normal" language="R" value="output = qplot(Petal.Width, Sepal.Length, data = iris, color = Species)">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a_250086512.a1061211060" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a_1523366022.a_250086512.a1061211060.a1202917863" mode="normal" language="Html" value="DataFrame iris as CSV(&quot;data/iris.csv&quot;)
								Chart(input=iris, query=&quot;&quot;) chart">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a_516420779" format="h6" mode="normal" value="No facets with Image output">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a803152855" format="filled" layout="vertical" spacing="8">
							<UiChart context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a803152855.a_1432157794">
							</UiChart>
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a803152855.a_332930901" mode="normal" language="R" value="set.seed(100);\\n
							d = diamonds[sample(nrow(diamonds), 1000), ];\\n
							output = ggplot(data = d, aes(x = carat, y = price)) + geom_point(aes(text = paste(&quot;Clarity:&quot;, clarity)), size = 4) + geom_smooth(aes(colour = cut, fill = cut)) + facet_wrap(~ cut);">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a803152855.a1286824888" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1022821667.a688513528.a803152855.a1286824888.a1691151877" mode="normal" language="Html" value="DataFrame iris as CSV(&quot;data/iris.csv&quot;)
								Chart(input=iris, query=&quot;&quot;, output=Image) chart">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChartExamplesMold));
DisplayFactory.register("ChartExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ChartExamplesMold)));