import React from "react";
import { withStyles } from '@material-ui/core/styles';
import DisplaysTable11Mold from "ui-elements/gen/displays/items/Table11Mold";
import DisplaysTable12Mold from "ui-elements/gen/displays/items/Table12Mold";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import Table1RowNotifier from "alexandria-ui-elements/gen/displays/notifiers/RowNotifier";
import Table1RowRequester from "alexandria-ui-elements/gen/displays/requesters/RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Table1Row extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new Table1RowNotifier(this);
		this.requester = new Table1RowRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysTable11Mold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_919625166" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysTable11Mold>
				<DisplaysTable12Mold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a588850164" style={{width:"70%",paddingRight:"10px"}} hidden="Never"></DisplaysTable12Mold>
			</React.Fragment>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Table1Row));
DisplayFactory.register("Table1Row", withStyles(styles, { withTheme: true })(withSnackbar(Table1Row)));