import SignActionRequester from "./SignActionRequester"

export default class SignDocumentRequester extends SignActionRequester {
	constructor(element) {
		super(element);
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "execute", s: "signdocument", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	batchSuccess = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "batchSuccess", s: "signdocument", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "signdocument", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}