import Requester from "./Requester";

export default class ReelRequester extends Requester {
	constructor(element) {
		super(element);
	};
	fetch = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "fetch", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	signalsSorting = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "signalsSorting", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	first = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "first", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	previous = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "previous", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "next", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	last = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "last", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	changeScale = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "changeScale", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "reel", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}