import ActionableRequester from "./ActionableRequester"

export default class ExportRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	changeParams = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "changeParams", s: "export", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	execute = () => {
		if (this.addToHistory()) return;
		this.fileService.download({ app: this.element.context, op: "execute", s: "export", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "export", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}