import ActionableNotifier from "./ActionableNotifier"

export default class SignActionNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("format").toSelf().execute((parameters) => this.element.format(parameters.v));
		this.when("sign").toSelf().execute((parameters) => this.element.sign(parameters.v));
		this.pushLinked = true;
	};
}