import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class ReelNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refreshToolbar").toSelf().execute((parameters) => this.element.refreshToolbar(parameters.v));
		this.when("refreshSignalsSorting").toSelf().execute((parameters) => this.element.refreshSignalsSorting(parameters.v));
		this.when("refreshSignals").toSelf().execute((parameters) => this.element.refreshSignals(parameters.v));
		this.when("refreshNavigation").toSelf().execute((parameters) => this.element.refreshNavigation(parameters.v));
		this.pushLinked = true;
	};
}