import ActionableNotifier from "./ActionableNotifier"

export default class OpenSiteNotifier extends ActionableNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("open").toSelf().execute((parameters) => this.element.open(parameters.v));
		this.pushLinked = true;
	};
}