import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMap from "alexandria-ui-elements/src/displays/components/Map";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysMap1Mold from "ui-elements/gen/displays/items/Map1Mold";
import DisplaysMap2Mold from "ui-elements/gen/displays/items/Map2Mold";
import DisplaysMap3Mold from "ui-elements/gen/displays/items/Map3Mold";
import DisplaysMap4Mold from "ui-elements/gen/displays/items/Map4Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MapExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MapExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MapExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MapExamplesMoldNotifier(this);
		this.requester = new MapExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410.a_185457008" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410.a_1386814111" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410.a_1386814111.a_1273002339" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="zoom,maptype,scale,streetview,rotate,fullscreen">
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410.a1105707168" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a348910410.a1105707168.a_158870526" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon=&quot;icons/placemark.png&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859.a_363594846" format="h6" mode="normal" value="Clustered facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859.a1364770943" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859.a1364770943.a340519741" type="Cluster" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}} controls="zoom,maptype,scale,streetview,rotate,fullscreen">
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859.a_352630105" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_459750758.a_347360859.a_352630105.a1122899255" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Clustered&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923.a1407172863" format="h6" mode="normal" value="Heatmap facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923.a_150524599" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923.a_150524599.a211231486" type="Heatmap" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}} controls="zoom,maptype,scale,streetview,rotate,fullscreen">
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923.a_1549873945" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a81463923.a_1549873945.a1817619973" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Heatmap&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791.a592722199" format="h6" mode="normal" value="Kml facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791.a_1239649867" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791.a_1239649867.a_1660867104" type="Kml" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}} controls="zoom,maptype,scale,streetview,rotate,fullscreen">
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791.a_831474853" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_907671230.a_2001135791.a_831474853.a_1922963671" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Kml(layer=&quot;data/example.kml&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(MapExamplesMold));
DisplayFactory.register("MapExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(MapExamplesMold)));