import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PropertyMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import PropertyMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PropertyMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PropertyMoldNotifier(this);
		this.requester = new PropertyMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="airBottom" layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a187503373" format="body2 facetsAbsolute" mode="uppercase" value="">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1077005237" layout="horizontal startjustified">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1077005237.a_1830237600" format="h6" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1077005237.a_7308261" format="h6" mode="normal" value=":  ">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1077005237.a_1830035697" format="h6 widgetType" mode="lowercase">
					</UiText>
				</UiBlock>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a312111403" format="body2" mode="normal" value="">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834309157" layout="horizontal">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834309157.a1939673282" format="body2 valuesLabelFormat" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834309157.a_722674253" format="body2 widgetType" mode="normal" value=":  ">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1834309157.a1324712274" format="body2" mode="normal">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(PropertyMold));
DisplayFactory.register("PropertyMold", withStyles(styles, { withTheme: true })(withSnackbar(PropertyMold)));