import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class TimelineNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("refreshHistory").toSelf().execute((parameters) => this.element.refreshHistory(parameters.v));
		this.when("refreshMeasurementsVisibility").toSelf().execute((parameters) => this.element.refreshMeasurementsVisibility(parameters.v));
		this.when("refreshMeasurementsSorting").toSelf().execute((parameters) => this.element.refreshMeasurementsSorting(parameters.v));
		this.when("refreshSummary").toSelf().execute((parameters) => this.element.refreshSummary(parameters.v));
		this.when("showHistoryDialog").toSelf().execute((parameters) => this.element.showHistoryDialog(parameters.v));
		this.pushLinked = true;
	};
}