import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysItemMold from "ui-elements/gen/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map4MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Map4MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Map4Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map4MoldNotifier(this);
		this.requester = new Map4MoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1778682019">
				</DisplaysItemMold>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Map4Mold));
DisplayFactory.register("Map4Mold", withStyles(styles, { withTheme: true })(withSnackbar(Map4Mold)));