import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NumberExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NumberExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NumberExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NumberExamplesMoldNotifier(this);
		this.requester = new NumberExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413.a1682844052" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413.a_1938199425" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413.a_1938199425.a1741434098" format="body1 widgetDemo" style="Number" value={0.0} decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413.a_1938199425.a_340082701" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1074975413.a_1938199425.a_340082701.a_1115528958" mode="normal" language="Html" value="Number(value=10, label=&quot;Campo num&eacute;rico&quot;) number1&lt;br/&gt;
								in java called to number1.countDecimals(10)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572.a_1719837546" format="h6" mode="normal" value="No facets with prefix and suffix">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572.a868838138" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572.a868838138.a1870516818" format="body1 widgetDemo" style="Number" value={0.0} prefix="Amount" suffix="$" decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572.a868838138.a185880189" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a2137681572.a868838138.a185880189.a_1625139614" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, prefix=&quot;Amount&quot;, suffix=&quot;$&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775.a_1562504750" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775.a1678836807" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775.a1678836807.a_1417143524" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true} helperText="Some important helper text">
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775.a1678836807.a_417419217" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106675920.a1795202775.a1678836807.a_417419217.a652665217" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable(helperText=&quot;Some important helper text&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640.a_1016983072" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640.a_386619781" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640.a_386619781.a2128682261" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640.a_386619781.a405214524" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a458470640.a_386619781.a405214524.a121014063" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076.a_1183793663" format="h6" mode="normal" value="No facets, Currency style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076.a_1903600132" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076.a_1903600132.a_1684491039" format="body1 widgetDemo" style="Currency" value={1.0E8} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076.a_1903600132.a758410072" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_966135076.a_1903600132.a758410072.a1248471403" mode="normal" language="Html" value="Number(value=100000000, style=Currency, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952.a_1390200387" format="h6" mode="normal" value="No facets, Bytes style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952.a_2072441676" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952.a_2072441676.a748239457" format="body1 widgetDemo" style="Bytes" value={2.3232323E7} decimals={2} expanded={false}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952.a_2072441676.a1968755396" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2013962967.a_13433952.a_2072441676.a1968755396.a_131650846" mode="normal" language="Html" value="Number(value=23232323, style=Bytes, countDecimals=2, expanded=false)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380.a_1271570933" format="h6" mode="normal" value="No facets, Exponential style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380.a_1883525895" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380.a_1883525895.a_1313373260" format="body1 widgetDemo" style="Exponential" value={1.2398734202E7} decimals={2} expanded={false}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380.a_1883525895.a_132280778" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_977635391.a615491380.a_1883525895.a_132280778.a1348432012" mode="normal" language="Html" value="Number(value=12398734.202, style=Exponential, countDecimals=2, expanded=false)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold));
DisplayFactory.register("NumberExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold)));