import BaseSelectorRequester from "./BaseSelectorRequester"

export default class SelectorComboBoxRequester extends BaseSelectorRequester {
	constructor(element) {
		super(element);
	};
	updateSelection = (value) => {
		if (this.addToHistory(value)) return;
		this.pushService.send({ app: this.element.context, op: "updateSelection", s: "selectorcombobox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	refresh = () => {
		if (this.addToHistory()) return;
		this.pushService.send({ app: this.element.context, op: "refresh", s: "selectorcombobox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	didMount = () => {
		this.pushService.send({ op: "didMount", s: "selectorcombobox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}