import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716.a1753929014" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716.a997547231" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716.a880155795" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716.a880155795.a_2055530039" mode="normal" value="home">
							</UiText>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1749587909.a1040645716.a880155795.a_729033058" title="widgets" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164630808" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164630808.a679060678" layout="vertical center" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164630808.a679060678.a_519822335" format="h1 textCentered" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164630808.a679060678.a1474851930" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164630808.a679060678.a_502610094" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881" format="containerAirLarge" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a237903697" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a237903697.a1727045620" format="h1 air" mode="normal" value="Why intino?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583" layout="horizontal centercenter" width="-1px" height="300px" spacing="40">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1968609786" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1968609786.a_1712193058" format="h5 cardTitle" mode="normal" value="flexibility">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1968609786.a128913698" format="h5 cardContent" mode="normal" value="Extending benefits beyond software development into modifiability. With intino, software evolution is tailor-made, that is evolving systems built specifically for the needs of particular customer">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_460081619" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_460081619.a_1137423769" format="h5 cardTitle" mode="normal" value="reuse">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_460081619.a1807478789" format="h5 cardContent" mode="normal" value="Developing core components that can be reused. This is the strategy that creates an opportunity for benefits in reducing the effort and costs costs required to create, deploy and software">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1766670503" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1766670503.a358423790" format="h5 cardTitle" mode="normal" value="quality">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558861881.a_963557655.a_72409583.a_1766670503.a1606855621" format="h5 cardContent" mode="normal" value="Lowering the complexity of product line development. Application developers can focus on user requirements, getting advantage on the platform architecture that provides a stable quality">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505881385" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505881385.a_1855765154" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505881385.a_1855765154.a_2003763959" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505881385.a_1855765154.a_2003763959.a_544926240" format="h2 air white" mode="normal" value="What does it look like?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a505881385.a_1855765154.a1611988275" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615425966" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615425966.a_937063317" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615425966.a_937063317.a205183516" format="h1" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615425966.a_937063317.a_1048617513" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615425966.a_937063317.a1268887759" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));