import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiImageAvatar from "alexandria-ui-elements/src/displays/components/ImageAvatar";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ImageExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ImageExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ImageExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ImageExamplesMoldNotifier(this);
		this.requester = new ImageExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178.a987692646" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178.a_573419925" format="filled" layout="vertical" spacing="8">
							<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178.a_573419925.a1277175006" format="widgetDemo" width="200px" height="150px">
							</UiImage>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178.a_573419925.a_1066779567" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a1634292178.a_573419925.a_1066779567.a255058056" mode="normal" language="Html" value="Image(defaultValue=&quot;images/image.jpg&quot;, format=widgetDemo) image1 as Absolute(width=300px, height=150px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270.a_1398793245" format="h6" mode="normal" value="Avatar facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270.a_1478678569" format="filled" layout="vertical" spacing="8">
							<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270.a_1478678569.a_519776352" format="widgetDemo" color="#3F52B5" width="75px" height="75px">
							</UiImageAvatar>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270.a_1478678569.a_533016883" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a_1907789270.a_1478678569.a_533016883.a1763533386" mode="normal" language="Html" value="Image image2 as Avatar(&quot;Intino avatar&quot;, format=widgetDemo, color=&quot;#3F52B5&quot;) Absolute(width=75px, height=75px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086.a1233163138" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086.a_1193551586" format="filled" layout="vertical" spacing="8">
							<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086.a_1193551586.a1978239586" format="widgetDemo" width="200px" height="200px">
							</UiImageEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086.a_1193551586.a_2069722910" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1920872516.a2061535086.a_1193551586.a_2069722910.a_1022958580" mode="normal" language="Html" value="Image(defaultValue=&quot;images/image.jpg&quot;) image3 as Editable(format=widgetDemo) Absolute(width=200px, height=200px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940.a1646786306" format="h6" mode="normal" value="No facets (allowFullscreen)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940.a_1334280956" format="filled" layout="vertical" spacing="8">
							<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940.a_1334280956.a_274895790" format="widgetDemo" width="200px" height="150px" allowFullscreen={true}>
							</UiImage>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940.a_1334280956.a_1794244235" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1159249003.a1476733940.a_1334280956.a_1794244235.a2076929682" mode="normal" language="Html" value="Image(defaultValue=&quot;images/image.jpg&quot;, allowFullscreen=true) as Absolute(width=300px, height=150px)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ImageExamplesMold));
DisplayFactory.register("ImageExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ImageExamplesMold)));