import Requester from "./Requester";

export default class GroupingToolbarRequester extends Requester {
	constructor(element) {
		super(element);
	};
	apply = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "apply", s: "groupingtoolbar", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	reset = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "reset", s: "groupingtoolbar", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	removeFilter = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "removeFilter", s: "groupingtoolbar", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "groupingtoolbar", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}