import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysItemMold from "ui-elements/gen/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map3MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Map3MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Map3Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map3MoldNotifier(this);
		this.requester = new Map3MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1966682177">
				</DisplaysItemMold>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Map3Mold));
DisplayFactory.register("Map3Mold", withStyles(styles, { withTheme: true })(withSnackbar(Map3Mold)));