import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImageAvatar from "alexandria-ui-elements/src/displays/components/ImageAvatar";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ItemMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ItemMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ItemMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ItemMoldNotifier(this);
		this.requester = new ItemMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1211036330" layout="horizontal center" spacing="8">
					<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1211036330.a_1928025295">
					</UiImageAvatar>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1211036330.a1055717916" mode="normal">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ItemMold));
DisplayFactory.register("ItemMold", withStyles(styles, { withTheme: true })(withSnackbar(ItemMold)));