import BaseImageRequester from "./BaseImageRequester"

export default class ImageEditableRequester extends BaseImageRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.fileService.upload({ app: this.element.context, op: "notifyChange", s: "imageeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit());
	};
	download = () => {
	    if (this.addToHistory()) return;
	    this.fileService.download({ app: this.element.context, op: "download", s: "imageeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "imageeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}