import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TextExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TextExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TextExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TextExamplesMoldNotifier(this);
		this.requester = new TextExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550.a_1047510664" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550.a_20552771" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550.a_20552771.a1900505514" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550.a_20552771.a_1123692422" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1142935550.a_20552771.a_1123692422.a_1194236294" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text1">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089.a1583555129" format="h6" mode="normal" value="No facets with label">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089.a884494623" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089.a884494623.a1703992010" label="título del campo" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089.a884494623.a1224608110" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1578433089.a884494623.a1224608110.a_1698871398" mode="normal" language="Html" value="Text text2 as Labeled(&quot;t&iacute;tulo del campo&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value=&quot;lorem ipsum&quot;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286.a1562424903" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286.a_1228748988" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286.a_1228748988.a_299975957" label="campo editable" format="body1 widgetDemo" mode="normal" placeholder="" helperText="Some important helper text">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286.a_1228748988.a_1459316771" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037007306.a1312850286.a_1228748988.a_1459316771.a_1042852703" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable(helperText=&quot;Some important helper text&quot;) Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042.a_218816362" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042.a_542853310" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042.a_542853310.a1991023372" label="campo editable" format="body1 widgetDemo" mode="normal" placeholder="">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042.a_542853310.a769670856" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a_1134285042.a_542853310.a769670856.a1736335014" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338.a1608899745" format="h6" mode="normal" value="Code facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338.a452712278" format="filled" layout="vertical" spacing="8">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338.a452712278.a_1401595845" format="body1 widgetDemo" mode="normal" language="Html" value="Text(value=&quot;lorem&quot;) text1">
							</UiTextCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338.a452712278.a1109399583" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a1412453338.a452712278.a1109399583.a_2092989681" mode="normal" language="Html" value="Text textCode1 as Code(language=Html)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;lorem&quot;) text1&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709.a_1853345288" format="h6" mode="normal" value="Code and Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709.a_531569277" format="filled" layout="vertical" spacing="8">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709.a_531569277.a_1825907080" format="body1 widgetDemo" mode="normal" language="Html" value="&lt;div&gt;Here goes code&lt;/div&gt;">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709.a_531569277.a_2029735008" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196353823.a737216709.a_531569277.a_2029735008.a1797104332" mode="normal" language="Html" value="Text textCode1 as Code(language=Html) Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;lt;div&amp;gt;Here goes code&amp;lt;/div&amp;gt;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TextExamplesMold));
DisplayFactory.register("TextExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(TextExamplesMold)));