import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiToolbar from "alexandria-ui-elements/src/displays/components/Toolbar";
import UiDownloadSelection from "alexandria-ui-elements/src/displays/components/DownloadSelection";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysDownloadSelectionMold from "ui-elements/gen/displays/items/DownloadSelectionMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DownloadSelectionExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DownloadSelectionExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DownloadSelectionExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DownloadSelectionExamplesMoldNotifier(this);
		this.requester = new DownloadSelectionExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a_650655633" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1576635207" format="filledNoAir" layout="vertical" spacing="8">
							<UiToolbar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1576635207.a636664810">
								<UiDownloadSelection context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1576635207.a636664810.a_1248787139" title="download" target="self" mode="Button" affirmed="Are you sure you want to download selection?" readonly={true} size="Medium">
								</UiDownloadSelection>
							</UiToolbar>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1576635207.a_1213602937" pageSize={20} itemHeight={60} scrollingMark={true} selection="multiple">
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1140616735" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_138393856.a2101686420.a1140616735.a488161785" mode="normal" language="Html" value="Toolbar toolbar as Linked(to=list)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;download&quot;) download as Download(context=Selection) Affirmed(&quot;Are you sure you want to download selection?&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list as Selectable(multiple=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) mold &gt; Text firstName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DownloadSelectionExamplesMold));
DisplayFactory.register("DownloadSelectionExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DownloadSelectionExamplesMold)));