import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDashboardShiny from "alexandria-ui-elements/src/displays/components/DashboardShiny";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDashboardMetabase from "alexandria-ui-elements/src/displays/components/DashboardMetabase";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DashboardExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DashboardExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DashboardExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DashboardExamplesMoldNotifier(this);
		this.requester = new DashboardExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a1696068047" format="h6" mode="normal" value="Shiny facet with adminMode(true)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a_1558191207" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a_1558191207.a_893575907" layout="vertical" width="-1px" height="600px">
								<UiDashboardShiny context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a_1558191207.a_893575907.a_1060957900">
								</UiDashboardShiny>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a_1558191207.a_1477859802" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_1697818398.a_1558191207.a_1477859802.a1543656356" mode="normal" language="Html" value="Dashboard dashboard as Shiny&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;serverScript = &quot;data/dashboard/server.R&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;uiScript = &quot;data/dashboard/ui.R&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Parameter(&quot;param1&quot;, &quot;abcd&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a_855515990" format="h6" mode="normal" value="Metabase facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126" layout="vertical" width="-1px" height="600px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_874022185" layout="vertical flexible">
									<UiDashboardMetabase context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_874022185.a_1422271609">
									</UiDashboardMetabase>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_619228896" format="air" layout="horizontal end centercenter">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_619228896.a725571499" format="airRight" layout="vertical" width="100px" height="-1px">
										<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_619228896.a725571499.a1817518616" label="Dashboard" style="Number" value={0.0} min={0.0} max={1000.0} step={-1.0} decimals={0} expanded={true}>
										</UiNumberEditable>
									</UiBlock>
									<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_1717622126.a_619228896.a_78800943" label="Secret Key" mode="normal" placeholder="Fill secret key provided by Metabase">
									</UiTextEditable>
								</UiBlock>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_568724801" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_54465947.a_264415831.a1147718069.a_568724801.a_1758327055" mode="normal" language="Html" value="Dashboard dashboard as Metabase&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;url = &quot;http://localhost:3000&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;secretKey = &quot;&quot;&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DashboardExamplesMold));
DisplayFactory.register("DashboardExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DashboardExamplesMold)));