import React from "react";
import { withStyles } from '@material-ui/core/styles';
import DisplaysTable21Mold from "ui-elements/gen/displays/items/Table21Mold";
import DisplaysTable22Mold from "ui-elements/gen/displays/items/Table22Mold";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import Table2RowNotifier from "alexandria-ui-elements/gen/displays/notifiers/RowNotifier";
import Table2RowRequester from "alexandria-ui-elements/gen/displays/requesters/RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Table2Row extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new Table2RowNotifier(this);
		this.requester = new Table2RowRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysTable21Mold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a333709748" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysTable21Mold>
				<DisplaysTable22Mold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2138828979" style={{width:"70%",paddingRight:"10px"}} hidden="Never"></DisplaysTable22Mold>
			</React.Fragment>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Table2Row));
DisplayFactory.register("Table2Row", withStyles(styles, { withTheme: true })(withSnackbar(Table2Row)));