import Requester from "./Requester";

export default class ProxyDisplayRequester extends Requester {
	constructor(element) {
		super(element);
	};
	connected = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "connected", s: "proxydisplay", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	ready = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "ready", s: "proxydisplay", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	notifyMessage = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "notifyMessage", s: "proxydisplay", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "proxydisplay", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}