import Requester from "./Requester";

export default class BaseDigitalSignatureRequester extends Requester {
	constructor(element) {
		super(element);
	};
	success = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "success", s: "basedigitalsignature", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	failure = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "failure", s: "basedigitalsignature", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "basedigitalsignature", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}