import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiSelectorCollectionBox from "alexandria-ui-elements/src/displays/components/SelectorCollectionBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysSelector8ListMold from "ui-elements/gen/displays/items/Selector8ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SelectorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SelectorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SelectorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SelectorExamplesMoldNotifier(this);
		this.requester = new SelectorExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a1366869238" format="h6" mode="normal" value="Tabs facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826" multipleSelection={false} scrollButtons="On">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826.a_685079136" name="tabOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826.a_685079135" name="tabOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826.a_685079134" name="tabOption3" mode="normal" value="option 3">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826.a_685079133" name="tabOption4" mode="normal" value="option 4">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a971893873.a_306608826.a_685079132" name="tabOption5" mode="normal" value="option 5">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a1462318803" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a613170577.a1462318803.a_314311381" mode="normal" language="Html" value="Selector as Tabs&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) tabOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) tabOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) tabOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a199881765" format="h6" mode="normal" value="Menu facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a1506182956" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a1506182956.a1135575790" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a1506182956.a1135575790.a1705180204" name="menuOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a1506182956.a1135575790.a1705180205" name="menuOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a1506182956.a1135575790.a1705180206" name="menuOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorMenu>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a723230235" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a_24240787.a723230235.a885141551" mode="normal" language="Html" value="Selector as Menu(layout=Vertical)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) menuOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) menuOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) menuOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a_2099903098" format="h6" mode="normal" value="ComboBox facet with Traceable (cookie is used)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a869536862" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a869536862.a1298070569" traceable={true} multipleSelection={false} maxMenuHeight={300}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a869536862.a1298070569.a1964861993" name="comboBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a869536862.a1298070569.a1964861994" name="comboBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a869536862.a1298070569.a1964861995" name="comboBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a_1076036667" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223062604.a2019978060.a_1076036667.a1381213542" mode="normal" language="Html" value="Selector as ComboBox Traceable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) comboBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) comboBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) comboBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a_1506895721" format="h6" mode="normal" value="ListBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a1086401274" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a1086401274.a1167162341" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a1086401274.a1167162341.a343245033" name="listBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a1086401274.a1167162341.a343245034" name="listBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a1086401274.a1167162341.a343245035" name="listBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorListBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a235758493" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1384252271.a235758493.a442692330" mode="normal" language="Html" value="Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) listBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) listBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) listBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_1854759072" format="h6" mode="normal" value="RadioBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_306399084" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_306399084.a_1098814325" multipleSelection={false} selected="radioBoxOption1" layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_306399084.a_1098814325.a1365333176" name="radioBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_306399084.a_1098814325.a1365333177" name="radioBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_306399084.a_1098814325.a1365333178" name="radioBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorRadioBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_237939422" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a1181761947.a_237939422.a1056017230" mode="normal" language="Html" value="Selector as RadioBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) radioBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) radioBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) radioBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a207944843" format="h6" mode="normal" value="ToggleBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a34330249" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a34330249.a_936319546" multipleSelection={false} selected="toggleBoxOption1" layout="Horizontal" size="Medium">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a34330249.a_936319546.a607589854" name="toggleBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a34330249.a_936319546.a607589855" name="toggleBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a34330249.a_936319546.a607589856" name="toggleBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorToggleBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a_2145990657" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_159823447.a_460386818.a_2145990657.a_2066375711" mode="normal" language="Html" value="Selector as ToggleBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) toggleBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) toggleBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) toggleBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_1928336126" format="h6" mode="normal" value="CheckBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_796851257" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_796851257.a1075934013" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_796851257.a1075934013.a_95593417" name="checkBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_796851257.a1075934013.a_95593416" name="checkBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a_796851257.a1075934013.a_95593415" name="checkBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorCheckBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a931283401" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_478174133.a931283401.a2005338049" mode="normal" language="Html" value="Selector as CheckBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_417187041" format="h6" mode="normal" value="CollectionBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_304864771" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCollectionBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_304864771.a_1190042653" multipleSelection={false} allowOther="true">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_304864771.a_1190042653.a_574548709selector8" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiSelectorCollectionBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_2016493409" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_633478393.a_2071364876.a_2016493409.a1448042988" mode="normal" language="Html" value="Selector as CollectionBox(allowOther=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold));
DisplayFactory.register("SelectorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold)));