import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Multiple2TemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import Multiple2TemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Multiple2Template extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new Multiple2TemplateNotifier(this);
		this.requester = new Multiple2TemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_392972103" mode="normal" placeholder="">
				</UiTextEditable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Multiple2Template));
DisplayFactory.register("Multiple2Template", withStyles(styles, { withTheme: true })(withSnackbar(Multiple2Template)));