import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiActionToggle from "alexandria-ui-elements/src/displays/components/ActionToggle";
import UiActionSplit from "alexandria-ui-elements/src/displays/components/ActionSplit";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ActionableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ActionableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ActionableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ActionableExamplesMoldNotifier(this);
		this.requester = new ActionableExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635.a1152032633" format="h6" mode="normal" value="Link">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635.a_787743677" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635.a_787743677.a_1047427129" title="operation" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635.a335196205" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a832664635.a335196205.a_1484521610" mode="normal" language="Html" value="Link(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975.a_918222445" format="h6" mode="normal" value="Button">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975.a_431816442" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975.a_431816442.a460124681" title="operation" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975.a_270807179" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a_1775193975.a_270807179.a_236174449" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674.a1112508581" format="h6" mode="normal" value="IconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674.a104443175" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674.a104443175.a1967676491" title="operation" target="self" mode="IconButton" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674.a_396253675" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1736227479.a1540169674.a_396253675.a_293425309" mode="normal" language="Html" value="IconButton(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560.a2084079973" format="h6" mode="normal" value="MaterialIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560.a_719147690" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560.a_719147690.a_1830856245" title="operation" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560.a945419568" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1955301560.a945419568.a788355568" mode="normal" language="Html" value="MaterialIconButton(title=&quot;operation&quot;,icon=&quot;Add&quot;) as Action&lt;br/&gt;&lt;br/&gt;
							for icons gallery, refer to &lt;a href=&quot;https://material.io/tools/icons&quot; target=&quot;_blank&quot;&gt;material.io&lt;/a&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080.a_1402201921" format="h6" mode="normal" value="Affirmed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080.a784158756" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080.a784158756.a_828863060" title="operation" target="self" mode="Button" affirmed="Are you sure you want to execute operation?" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080.a110792910" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a_1199024080.a110792910.a738061204" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action Affirmed(&quot;Are you sure you want to execute operation?&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a313041735" format="h6" mode="normal" value="Highlight attribute">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a_112682637" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a_112682637.a678688750" title="operation 1" target="self" mode="Button" size="Medium" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a_112682637.a678688751" title="operation 2" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a2043155227" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_786834781.a937485649.a2043155227.a_594314829" mode="normal" language="Html" value="Button(title=&quot;operation 1&quot;, highlight=&quot;Outline&quot;) as Action&lt;br/&gt;
							Button(title=&quot;operation 2&quot;, highlight=&quot;Fill&quot;) as Action&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389.a_366735569" format="h6" mode="normal" value="Switch">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389.a_1570608435" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389.a_1570608435.a164006061" title="edition" target="self" mode="Link" size="Medium" state="Off">
							</UiActionSwitch>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389.a_889507887" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1314348389.a_889507887.a_223439732" mode="normal" language="Html" value="Switch(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300.a_1543007277" format="h6" mode="normal" value="Signed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300.a1510461244" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300.a1510461244.a1671557871" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300.a_709272736" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_875722300.a_709272736.a_1521315875" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674.a1793391900" format="h6" mode="normal" value="Signed facet with reason property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674.a_1340473499" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674.a_1340473499.a_231847928" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:"Fill reason"}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674.a_676873506" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1518337489.a_1099177674.a_676873506.a_1090864498" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;, reasonText=&quot;Fill reason&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715.a_1898263822" format="h6" mode="normal" value="Toggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715.a931608587" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715.a931608587.a324361319" title="edition" target="self" mode="Toggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715.a_2031425932" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1561640715.a_2031425932.a_1207093090" mode="normal" language="Html" value="Toggle(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522.a1576169335" format="h6" mode="normal" value="IconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522.a_473922012" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522.a_473922012.a_186172856" title="operation" target="self" mode="IconToggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522.a1135967297" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_3587522.a1135967297.a_2004386471" mode="normal" language="Html" value="IconToggle(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817.a_1051498130" format="h6" mode="normal" value="MaterialIconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817.a_1322425655" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817.a_1322425655.a_696707034" title="edition" target="self" mode="MaterialIconToggle" icon="FilterList" size="Medium" state="On">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817.a_1337897614" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2051674660.a_1079267817.a_1337897614.a_412900353" mode="normal" language="Html" value="MaterialIconToggle(title=&quot;edition&quot;, state=On, icon=&quot;FilterList&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813.a_624707308" format="h6" mode="normal" value="SplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813.a_2089137000" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813.a_2089137000.a_893287970" title="edition" target="self" mode="SplitButton" size="Medium" options={["option 1","option 2"]} defaultOption="option 1">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813.a1889285630" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a1232741813.a1889285630.a721423576" mode="normal" language="Html" value="SplitButton(title=&quot;edition&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767.a77065921" format="h6" mode="normal" value="AvatarIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767.a1588710341" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767.a1588710341.a_1403822146" title="I am avatar" target="self" mode="AvatarIconButton" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767.a_801911648" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_97837003.a_826463767.a_801911648.a1445255317" mode="normal" language="Html" value="AvatarIconButton(title=&quot;I am avatar&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold));
DisplayFactory.register("ActionableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold)));