import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysItemMold from "ui-elements/gen/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map2MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Map2MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Map2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map2MoldNotifier(this);
		this.requester = new Map2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1679529675">
				</DisplaysItemMold>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Map2Mold));
DisplayFactory.register("Map2Mold", withStyles(styles, { withTheme: true })(withSnackbar(Map2Mold)));