import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiLocation from "alexandria-ui-elements/src/displays/components/Location";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiLocationEditable from "alexandria-ui-elements/src/displays/components/LocationEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LocationExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LocationExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LocationExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LocationExamplesMoldNotifier(this);
		this.requester = new LocationExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593.a_1983121408" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593.a531418593" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593.a531418593.a_429932134" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593.a531418593.a_782228399" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1231737593.a531418593.a_782228399.a_474715924" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255.a_847858747" format="h6" mode="normal" value="No facets with location">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255.a_337127758" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255.a_337127758.a_2109102786" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255.a_337127758.a_625212990" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596447674.a1244607255.a_337127758.a_625212990.a_352593264" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value='POINT(28.146773457066104,-15.146773457066104)'&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292.a1554158630" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292.a_194680492" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292.a_194680492.a_1946608007" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} controls="all">
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292.a_194680492.a_1863766480" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a_269114292.a_194680492.a_1863766480.a830881355" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480.a_592200320" format="h6" mode="normal" value="Editable facet with modes">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480.a1404186371" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480.a1404186371.a669188637" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} modes={["Rectangle"]} controls="all">
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480.a1404186371.a1105524613" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1648441380.a1959474480.a1404186371.a1105524613.a_1988653584" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;modes=Rectangle&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold));
DisplayFactory.register("LocationExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold)));