import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGrouping from "alexandria-ui-elements/src/displays/components/Grouping";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiGroupingComboBox from "alexandria-ui-elements/src/displays/components/GroupingComboBox";
import DisplaysGrouping1Mold from "ui-elements/gen/displays/items/Grouping1Mold";
import DisplaysGrouping2Mold from "ui-elements/gen/displays/items/Grouping2Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import GroupingExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import GroupingExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GroupingExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new GroupingExamplesMoldNotifier(this);
		this.requester = new GroupingExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a484786766" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_1072265963" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_1072265963.a1656192535" format="containerAirMedium" layout="vertical" width="200px" height="-1px" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_1072265963.a1656192535.a_1140258110" label="gender" format="whiteBackground" pageSize={5}>
								</UiGrouping>
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_1072265963.a1656192535.a658203683" label="age group" format="whiteBackground" pageSize={5}>
								</UiGrouping>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_1072265963.a_1145765181" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_797609427" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1597573056.a_797609427.a_1325807217" mode="normal" language="Html" value="Grouping(collections=list1) gender as Labeled(&quot;gender&quot;)&lt;br/&gt;
							Grouping(collections=list1) ageGroup as Labeled(&quot;age group&quot;)&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a_40547739" format="h6" mode="normal" value="ComboBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a726031802" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a726031802.a2051168410" format="containerAirMedium" layout="horizontal" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a726031802.a2051168410.a_1276914874" label="gender" format="whiteBackground">
								</UiGroupingComboBox>
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a726031802.a2051168410.a_1819928601" label="age group" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a726031802.a_1986129913" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a271146800" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271353277.a1405245005.a271146800.a2147179715" mode="normal" language="Html" value="Grouping(collections=list2) gender as Labeled(&quot;gender&quot;) ComboBox&lt;br/&gt;
							Grouping(collections=list2) ageGroup as Labeled(&quot;age group&quot;) ComboBox&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list2&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) groupingMold
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_1259696855" format="h6" mode="normal" value="No facets with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_1730351333" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_1730351333.a_1917823317" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_1730351333.a_1917823317.a_212311475" label="country" format="whiteBackground" pageSize={6}>
								</UiGrouping>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_494658526" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a_1229789986.a_494658526.a827489139" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;)&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_514700285" format="h6" mode="normal" value="ComboBox facet with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_618370935" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_618370935.a_76235877" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGroupingComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_618370935.a_76235877.a_376631762" label="country" format="whiteBackground">
								</UiGroupingComboBox>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_52291211" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_837264822.a1347014193.a_52291211.a1281798663" mode="normal" language="Html" value="Grouping(collections=empty) country as Labeled(&quot;country&quot;) ComboBox&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a_512201279" format="h6" mode="normal" value="AttachedTo facet with many options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a_356365850" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a_356365850.a_808049401" format="containerAirMedium" layout="vertical" width="100.0%" height="100.0%" spacing="24">
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a_356365850.a_808049401.a_411869330" label="country" format="whiteBackground" pageSize={6}>
								</UiGrouping>
								<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a_356365850.a_808049401.a_1037234692" label="city" format="whiteBackground" pageSize={6}>
								</UiGrouping>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a1038938856" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318882152.a_82478127.a1038938856.a880909880" mode="normal" language="Html" value="Grouping(collections=empty,pageSize=6) country as Labeled(&quot;country&quot;)
							Grouping(collections=empty,pageSize=6) city as Labeled(&quot;city&quot;) AttachedTo(grouping=country)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(GroupingExamplesMold));
DisplayFactory.register("GroupingExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(GroupingExamplesMold)));