import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDigitalSignatureAutoFirma from "alexandria-ui-elements/src/displays/components/DigitalSignatureAutoFirma";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DigitalSignatureExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DigitalSignatureExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DigitalSignatureExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DigitalSignatureExamplesMoldNotifier(this);
		this.requester = new DigitalSignatureExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a_2050171324" format="h6" mode="normal" value="Sign by using @firma">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981" format="filledNoAir" layout="vertical centercenter">
							<UiDigitalSignatureAutoFirma context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a_720136888" signFormat="XAdES">
							</UiDigitalSignatureAutoFirma>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a267852181" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a267852181.a626766927" label="Signature" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a1417488845" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a1417488845.a1534876539" label="Signed by" mode="normal" cropWithEllipsis={40}>
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a_1470497127" format="airTop" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a1764011981.a_1470497127.a_180408543" label="Error" format="redColor" mode="normal">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a_156183670" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1913563133.a1782801219.a_156183670.a1726582012" mode="normal" language="Html" value="DigitalSignature autoFirma as AutoFirma&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold));
DisplayFactory.register("DigitalSignatureExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DigitalSignatureExamplesMold)));