import ActionableRequester from "./ActionableRequester"

export default class OpenDialogRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	execute = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "execute", s: "opendialog", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "opendialog", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}