import BaseFileRequester from "./BaseFileRequester"

export default class FileEditableRequester extends BaseFileRequester {
	constructor(element) {
		super(element);
	};
	notifyUploading = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ app: this.element.context, op: "notifyUploading", s: "fileeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.fileService.upload({ app: this.element.context, op: "notifyChange", s: "fileeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit());
	};
	downloadFile = () => {
	    if (this.addToHistory()) return;
	    this.fileService.download({ app: this.element.context, op: "downloadFile", s: "fileeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "fileeditable", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}