import CollectionNotifier from "./CollectionNotifier"

export default class MapNotifier extends CollectionNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("placeMarks").toSelf().execute((parameters) => this.element.placeMarks(parameters.v));
		this.when("updateCenter").toSelf().execute((parameters) => this.element.updateCenter(parameters.v));
		this.when("updateZoom").toSelf().execute((parameters) => this.element.updateZoom(parameters.v));
		this.pushLinked = true;
	};
}