import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Grouping2MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Grouping2MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Grouping2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Grouping2MoldNotifier(this);
		this.requester = new Grouping2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_296158274" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2097508567" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2097508567.a617609892" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2097508567.a1049977568" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Grouping2Mold));
DisplayFactory.register("Grouping2Mold", withStyles(styles, { withTheme: true })(withSnackbar(Grouping2Mold)));