import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAppDirectory from "alexandria-ui-elements/src/displays/components/AppDirectory";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import AppDirectoryExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import AppDirectoryExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class AppDirectoryExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new AppDirectoryExamplesMoldNotifier(this);
		this.requester = new AppDirectoryExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a623693765" format="h6" mode="normal" value="With source from file">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a588319688" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a588319688.a1626312075" layout="vertical" width="-1px" height="600px">
								<UiAppDirectory context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a588319688.a1626312075.a791461166" icon="Apps">
								</UiAppDirectory>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a588319688.a_1067104892" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_1621854838.a588319688.a_1067104892.a1224308926" mode="normal" language="Html" value="AppDirectory appDirectory&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as FromFile(file=&quot;path/to/file.tsv&quot;, separator=&quot;\\t&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a487884199" format="h6" mode="normal" value="With source from resource">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a826940895" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a826940895.a_354063854" layout="vertical" width="-1px" height="600px">
								<UiAppDirectory context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a826940895.a_354063854.a_440649391" icon="Apps">
								</UiAppDirectory>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a826940895.a1739493521" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a263135326.a826940895.a1739493521.a_178771103" mode="normal" language="Html" value="AppDirectory appDirectory&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as FromResource(path=&quot;data/app-directories/app-directory2.tsv&quot;, separator=&quot;\\t&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a2045363483" format="h6" mode="normal" value="With source inline">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a1852117048" format="filledNoAirExtraLarge" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a1852117048.a_483056366" layout="vertical" width="-1px" height="600px">
								<UiAppDirectory context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a1852117048.a_483056366.a_1672759948" icon="Apps">
								</UiAppDirectory>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a1852117048.a362537170" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a311498254.a_89198752.a1852117048.a362537170.a_1015747429" mode="normal" language="Html" value="AppDirectory appDirectory&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Source as Inline&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Application(&quot;app1&quot;, &quot;http://app1.html&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Application(&quot;app2&quot;, &quot;http://app2.html&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(AppDirectoryExamplesMold));
DisplayFactory.register("AppDirectoryExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(AppDirectoryExamplesMold)));