import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysMultipleExamplesMold from "ui-elements/gen/displays/templates/MultipleExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysDynamicTableExamplesMold from "ui-elements/gen/displays/templates/DynamicTableExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysGroupingToolbarExamplesMold from "ui-elements/gen/displays/templates/GroupingToolbarExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysBoardExamplesMold from "ui-elements/gen/displays/templates/BoardExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysLayerExamplesMold from "ui-elements/gen/displays/templates/LayerExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysMicroSiteExamplesMold from "ui-elements/gen/displays/templates/MicroSiteExamplesMold";
import DisplaysHtmlViewerExamplesMold from "ui-elements/gen/displays/templates/HtmlViewerExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="body1 airBottom" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a836628331" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a243910970" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a243910970.a_1332272946">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1121249878" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1121249878.a502495602">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_755910007" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_755910007.a_672299120">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a2064855712" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a2064855712.a_2142156464">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1095474501" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1095474501.a_1465630684">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_572414691" layout="vertical">
							<DisplaysMultipleExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_572414691.a1994613151">
							</DisplaysMultipleExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_323801565" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_323801565.a_636390613">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1161626670" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1161626670.a1303690260">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1595945899" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1595945899.a95759712">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1196121581" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1196121581.a1462697768">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_298247972" layout="vertical">
							<DisplaysDynamicTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_298247972.a_582767023">
							</DisplaysDynamicTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a95282337" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a95282337.a123531717">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1624625045" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1624625045.a_612369044">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1727403991" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1727403991.a_400937226">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1418168257" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1418168257.a_1065499294">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1709412707" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1709412707.a_2124783975">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1337391376" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1337391376.a1264120633">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1103750717" layout="vertical">
							<DisplaysGroupingToolbarExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1103750717.a_2067417861">
							</DisplaysGroupingToolbarExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_291496247" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_291496247.a1474374569">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_711724472" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_711724472.a1477226104">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1418817518" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a1418817518.a_1755084486">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1431708455" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1431708455.a134989744">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_272319189" layout="vertical">
							<DisplaysBoardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_272319189.a_1174113749">
							</DisplaysBoardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_493904555" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_493904555.a_679543764">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a2124417174" layout="vertical">
							<DisplaysLayerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a2124417174.a661624944">
							</DisplaysLayerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1528793250" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1528793250.a885107558">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_255790632" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_255790632.a1105968041">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1840567870" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1840567870.a719493642">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a430420972" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a430420972.a_539494139">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_148647146" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_148647146.a995363072">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1883569998" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1883569998.a172311639">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a727382896" layout="vertical">
							<DisplaysMicroSiteExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a727382896.a_1385069889">
							</DisplaysMicroSiteExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1346403670" layout="vertical">
							<DisplaysHtmlViewerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1442794779.a_1346403670.a_1352546827">
							</DisplaysHtmlViewerExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1278213870" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1278213870.a_1027260654" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a1278213870.a220802875" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a606219205" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a606219205.a_2035483906" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a606219205.a_2103042072" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a_1222239946" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a_1222239946.a_724892775" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a_1222239946.a630773088" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a47232644" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a47232644.a118776598" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1068958366.a47232644.a_891878253">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));