import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiHtmlViewer from "alexandria-ui-elements/src/displays/components/HtmlViewer";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HtmlViewerExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HtmlViewerExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HtmlViewerExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HtmlViewerExamplesMoldNotifier(this);
		this.requester = new HtmlViewerExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852.a382813672" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852.a1974655275" format="filledNoAirExtraLarge" layout="vertical">
							<UiHtmlViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852.a1974655275.a1950596668" content="<div style='font-weight:bold;background:black;color:white;padding:10px;margin:10px'>Hello world!</div>">
							</UiHtmlViewer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852.a1974655275.a1072838868" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a318037578.a1923418852.a1974655275.a1072838868.a_282852676" mode="normal" language="Html" value="HtmlViewer(content=&quot;&amp;lt;div style='font-weight:bold;background:black;color:white;padding:10px;margin:10px'&amp;gt;Hello world!&amp;lt;/div&amp;gt;&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(HtmlViewerExamplesMold));
DisplayFactory.register("HtmlViewerExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(HtmlViewerExamplesMold)));