import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import List3MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import List3MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class List3Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new List3MoldNotifier(this);
		this.requester = new List3MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1980223904" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(List3Mold));
DisplayFactory.register("List3Mold", withStyles(styles, { withTheme: true })(withSnackbar(List3Mold)));