import Requester from "./Requester";

export default class SearchBoxRequester extends Requester {
	constructor(element) {
		super(element);
	};
	search = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "search", s: "searchbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "searchbox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}