import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiBlockSplitter from "alexandria-ui-elements/src/displays/components/BlockSplitter";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockBadge from "alexandria-ui-elements/src/displays/components/BlockBadge";
import UiOpenPopover from "alexandria-ui-elements/src/displays/components/OpenPopover";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BlockExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BlockExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BlockExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BlockExamplesMoldNotifier(this);
		this.requester = new BlockExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a_507474792" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a886208011" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a886208011.a_677831765" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a886208011.a_677831765.a_1749149843" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a886208011.a_677831765.a_1147078623" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a886208011.a_677831765.a_1142987264" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a_434124908" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a1485109170.a_434124908.a553526086" mode="normal" language="Html" value="Block&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 2&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 3&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_456534602" format="h6" mode="normal" value="No facets with spacing">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_1484582255" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_1484582255.a1915201946" layout="vertical" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_1484582255.a1915201946.a_906745707" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_1484582255.a1915201946.a_304674487" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_1484582255.a1915201946.a1967587635" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_230646089" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_808066417.a_230646089.a1296820429" mode="normal" language="Html" value="DP8">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_312396618" format="h6" mode="normal" value="No facets with layout">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_1444689347" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_1444689347.a_471289927" layout="horizontal centercenter" width="-1px" height="175px" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_1444689347.a_471289927.a_1309633153" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_1444689347.a_471289927.a_707561933" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_1444689347.a_471289927.a_703470574" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_917555226" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34620065.a_651425317.a_917555226.a1288619884" mode="normal" language="Html" value="Horizontal CenterCenter">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805" layout="vertical" width="99.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a1803784888" format="h6" mode="normal" value="Parallax facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a1464804179" format="filled" layout="vertical" spacing="8">
							<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a1464804179.a_1964108635" layout="vertical" width="-1px" height="175px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a1464804179.a_1964108635.a_1777861515" layout="horizontal centercenter" width="100.0%" height="100.0%">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a1464804179.a_1964108635.a_1777861515.a643970473" format="body1 white higgerFont" mode="normal" value="pencils">
									</UiText>
								</UiBlock>
							</UiBlockParallax>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a_667728889" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_22961526.a555317805.a_667728889.a1786901485" mode="normal" language="Html" value="Block as Parallax(value=&quot;images/background1.jpg&quot;) Absolute(height=175px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_1702039395" format="h6" mode="normal" value="Drawer facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872.a387383621" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872.a307067438" layout="vertical" width="300px" height="-1px" position="Left" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872.a307067438.a_356668777" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872.a307067438.a_356668777.a_912040845" name="Block_70_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_2065895872.a307067438.a_356668777.a1626049739" name="Block_71_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_503734192" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1381005725.a_503734192.a2025560724" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a1080168515" format="h6" mode="normal" value="Drawer facet with position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576.a444604525" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576.a_770746286" layout="vertical" width="300px" height="-1px" position="Right" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576.a_770746286.a2106614742" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576.a_770746286.a2106614742.a_732006824" name="Block_89_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a_1042568576.a_770746286.a2106614742.a1683270737" name="Block_90_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a1461635640" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_773564482.a1461635640.a_1364763355" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock2)&lt;br/&gt;
							Block drawerBlock2 as Drawer(position=Right) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a590594157" format="h6" mode="normal" value="Drawer facet with Persistent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_564733327" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737" layout="vertical" width="300px" height="-1px" position="Left" variant="Persistent">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a1167947151" layout="horizontal endjustified">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a1167947151.a1137946623" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a_245226027">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a_679285267" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a_679285267.a1289755777" name="Block_110_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a_904697856.a_755388737.a_679285267.a_2043702531" name="Block_111_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a1892484177" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1084958587.a_1811292078.a1892484177.a_1557761005" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock3)&lt;br/&gt;
							Block drawerBlock3 as Drawer(variant=Persistent) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock3)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Divider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a139111912" format="h6" mode="normal" value="Drawer facet with PersistentAndMini variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573" format="filledNoAir" layout="horizontal">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048" layout="vertical" width="150px" height="-1px" position="Left" variant="PersistentAndMini">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a_1829780543" layout="horizontal endjustified" width="-1px" height="45px">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a_1829780543.a_192418446" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a_49047936">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a187388614" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a187388614.a_1031905635" icon="Build">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a187388614.a367283354" name="Block_133_75_01338594671" mode="normal" value="option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a1993081755" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a1993081755.a_2130258597" icon="Face">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a_90906048.a391908802.a1993081755.a_149278298" name="Block_134_74_1458356688" mode="normal" value="option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiBlockDrawer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a973547555" format="autoHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a973547555.a_260309032" color="white" layout="horizontal startjustified">
									<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a973547555.a_260309032.a_426461919" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
									</UiOpenDrawer>
								</UiBlock>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_976522573.a973547555.a921195425" format="containerAirMedium" mode="normal" value="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tellus lacus, tristique vitae lectus id, tristique cursus est. Mauris dui dolor, lacinia non accumsan sed, lacinia et eros. Ut eget ornare nunc. Vestibulum at porta tellus, in fringilla tellus. Nam ultricies porta nisi, ut sagittis est lacinia ac. Nunc aliquet, lacus a malesuada pretium, arcu lectus egestas purus, vel euismod nisl ante eget augue. Proin tristique, arcu vitae vehicula cursus, odio nulla congue erat, at porttitor magna dui id quam. In hac habitasse platea dictumst. Etiam id lorem cursus, ultricies felis ut, pretium ante. Aliquam sit amet tellus tellus. Maecenas eget faucibus enim. Pellentesque rutrum augue id pulvinar pharetra. Proin purus ex, tincidunt et posuere vel, dignissim a neque. Aenean quis imperdiet lectus. Pellentesque bibendum ante tincidunt feugiat pharetra. Fusce sollicitudin, magna in mollis vulputate, nunc nunc accumsan lectus, a blandit erat felis a lectus.">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_1699833495" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a_1983169053.a_1699833495.a_1342834743" mode="normal" language="Html" value="Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock1)
							Divider
							MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer(variant=PersistentAndMini) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_290503502" format="h6" mode="normal" value="Drawer facet with Permanent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_1612985101" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_1612985101.a_2068240665" layout="vertical" width="150px" height="-1px" spacing="8" position="Left" variant="Permanent">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_1612985101.a_2068240665.a1908775134" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_1612985101.a_2068240665.a1908775134.a1194141004" name="Block_156_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a_1612985101.a_2068240665.a1908775134.a_1492597550" name="Block_157_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a1386699528" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a977516380.a1386699528.a1172625369" mode="normal" language="Html" value="Block drawerBlock as Drawer(variant=Permanent) Absolute(width=150px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a1846972803" format="h6" mode="normal" value="Splitter facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312" format="filled" layout="vertical" spacing="8">
							<UiBlockSplitter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603" layout="horizontal" splitMobileLabel="Back">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603.a1969228658" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603.a1969228658.a1625263116" mode="normal" value="block 1">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603.a1969228658.a_1241018596" title="open 2" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603.a1969228659" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a_322272312.a1622247603.a1969228659.a1444098005" mode="normal" value="block 2">
									</UiText>
								</UiBlock>
							</UiBlockSplitter>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a1389481820" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1279143994.a408578410.a1389481820.a_1998548927" mode="normal" language="Html" value="Block(layout=Horizontal) as Splitter&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_1636891956" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_1714077490" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlockBadge context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_1714077490.a_702087258" layout="horizontal" mode="Normal" value={10}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_1714077490.a_702087258.a_998032145" format="body1" mode="normal" value="value">
								</UiText>
							</UiBlockBadge>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_657285582" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a869317873.a_657285582.a_246907897" mode="normal" language="Html" value="Block as Badge(value=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a_1878477475" format="h6" mode="normal" value="Popover facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a_1224356364" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a_1224356364.a1372656141" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseClick">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a_1224356364.a_998223214" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a_1224356364.a_998223214.a_943424554" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a703465784" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_980000760.a703465784.a1341479038" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a_1578106258" format="h6" mode="normal" value="Popover facet with trigger event">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a1018349831" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a1018349831.a_906847139" title="open popover" target="self" mode="Button" size="Medium" triggerEvent="MouseOver">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a1018349831.a_758949373" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a1018349831.a_758949373.a1031502276" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a_1621532267" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1992564063.a_1531554405.a_1621532267.a827719868" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock, triggerEvent=MouseOver)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold));
DisplayFactory.register("BlockExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold)));