import React from "react";
import { withStyles } from '@material-ui/core/styles';
import DisplaysDynFirstNameItem from "ui-elements/gen/displays/items/DynFirstNameItem";
import DisplaysDynLastNameItem from "ui-elements/gen/displays/items/DynLastNameItem";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import DynamicTable1RowNotifier from "alexandria-ui-elements/gen/displays/notifiers/RowNotifier";
import DynamicTable1RowRequester from "alexandria-ui-elements/gen/displays/requesters/RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DynamicTable1Row extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new DynamicTable1RowNotifier(this);
		this.requester = new DynamicTable1RowRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysDynFirstNameItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1389098956" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysDynFirstNameItem>
				<DisplaysDynLastNameItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1114668473" style={{width:"70%",paddingRight:"10px"}} hidden="Never"></DisplaysDynLastNameItem>
			</React.Fragment>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DynamicTable1Row));
DisplayFactory.register("DynamicTable1Row", withStyles(styles, { withTheme: true })(withSnackbar(DynamicTable1Row)));