import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseDialogNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("open").toSelf().execute(() => this.element.open());
		this.when("close").toSelf().execute(() => this.element.close());
		this.when("refreshTitle").toSelf().execute((parameters) => this.element.refreshTitle(parameters.v));
		this.when("refreshSize").toSelf().execute((parameters) => this.element.refreshSize(parameters.v));
		this.pushLinked = true;
	};
}