import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFrame from "alexandria-ui-elements/src/displays/components/Frame";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import FrameExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import FrameExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class FrameExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new FrameExamplesMoldNotifier(this);
		this.requester = new FrameExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039.a_1049083528" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039.a683921889" format="filledNoAirExtraLarge" layout="vertical" width="-1px" height="670px">
							<UiFrame context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039.a683921889.a1813581927"    width="100.0%" height="100.0%" url="https://intino.io">
							</UiFrame>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039.a683921889.a1011947498" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067634739.a_973376039.a683921889.a1011947498.a_101457744" mode="normal" language="Html" value="Frame(url=&quot;https://intino.io&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(FrameExamplesMold));
DisplayFactory.register("FrameExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(FrameExamplesMold)));