import Requester from "./Requester";

export default class BaseSliderRequester extends Requester {
	constructor(element) {
		super(element);
	};
	moved = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "moved", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	update = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "update", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectOrdinal = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "selectOrdinal", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	previous = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "previous", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	next = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "next", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	play = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "play", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	pause = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "pause", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "baseslider", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}