import BaseSelectorRequester from "./BaseSelectorRequester"

export default class SelectorRadioBoxRequester extends BaseSelectorRequester {
	constructor(element) {
		super(element);
	};
	select = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "select", s: "selectorradiobox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "selectorradiobox", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}