import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysMultipleExamplesMold from "ui-elements/gen/displays/templates/MultipleExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysDynamicTableExamplesMold from "ui-elements/gen/displays/templates/DynamicTableExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysGroupingToolbarExamplesMold from "ui-elements/gen/displays/templates/GroupingToolbarExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysLayerExamplesMold from "ui-elements/gen/displays/templates/LayerExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysMicroSiteExamplesMold from "ui-elements/gen/displays/templates/MicroSiteExamplesMold";
import DisplaysHtmlViewerExamplesMold from "ui-elements/gen/displays/templates/HtmlViewerExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="body1 airBottom" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a805608524" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1973846983" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1973846983.a1903839180">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a159635861" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a159635861.a_2098590220">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1321299336" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1321299336.a862928978">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a2033835905" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a2033835905.a76136027">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a981734842" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a981734842.a69597414">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1265516388" layout="vertical">
							<DisplaysMultipleExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1265516388.a_1483878115">
							</DisplaysMultipleExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_354821372" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_354821372.a_1119248501">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1192646477" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1192646477.a_780002380">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_621812054" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_621812054.a_963095458">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1227141388" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1227141388.a_620994872">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1885428955" layout="vertical">
							<DisplaysDynamicTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1885428955.a_841402861">
							</DisplaysDynamicTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a162289090" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a162289090.a_1508093339">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a931523348" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a931523348.a_1071415890">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a934759306" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a934759306.a772323969">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a456554240" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a456554240.a_872310624">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_2060212644" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_2060212644.a670390871">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a644289679" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a644289679.a805073787">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_846549538" layout="vertical">
							<DisplaysGroupingToolbarExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_846549538.a2044690907">
							</DisplaysGroupingToolbarExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_36759702" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_36759702.a13969289">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_723040599" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_723040599.a1995519640">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a457203501" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a457203501.a_1561895816">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1443024582" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1443024582.a1952824208">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1455518572" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1455518572.a707243476">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a2093397367" layout="vertical">
							<DisplaysLayerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a2093397367.a1219749606">
							</DisplaysLayerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1274056705" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1274056705.a_946648763">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1821418711" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1821418711.a_1460438938">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1761297729" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a1761297729.a28417863">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_262680725" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_262680725.a_488006808">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a106089399" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a106089399.a_836393249">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1914589805" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1914589805.a_1400846824">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a716066769" layout="vertical">
							<DisplaysMicroSiteExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a716066769.a2140727392">
							</DisplaysMicroSiteExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1697203607" layout="vertical">
							<DisplaysHtmlViewerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1313712060.a_1697203607.a_1790556330">
							</DisplaysHtmlViewerExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1474727375" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1474727375.a507339569" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1474727375.a_2036108132" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1674731970" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1674731970.a_1178322054" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a1674731970.a_1091924822" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_153727181" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_153727181.a1103872925" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_153727181.a_70291490" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_478071508" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_478071508.a_761280344" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572892099.a_478071508.a_667034934">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));