import CollectionRequester from "./CollectionRequester"

export default class PageCollectionRequester extends CollectionRequester {
	constructor(element) {
		super(element);
	};
	changePage = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "changePage", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	changePageSize = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "changePageSize", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	notifyItemsRendered = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "notifyItemsRendered", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	loadNextPage = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "loadNextPage", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	loadMoreItems = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "loadMoreItems", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "pagecollection", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}